
Type Demo11Screen extends TScreen

	Field border:TBorder
	Field agent:TAgent
	Field agent2:TAgent
	Field circleTex:TImage
	Field circleBody:TBody
	Field circleGeom:TGeom
	Field rectGeomList:TList = CreateList()
	Field rectTex:TImage
	Field spinnerOn:Int = True
	
	Field _firstRun:Int = True
	Method Update(delta:Float)
		If _firstRun Then
			 ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails()))
			_firstRun = False
		EndIf
		If spinnerOn Then
			circleBody.ApplyTorque(50000)
		End If
		HandleKeyboardInput()
		HandleMouseInput()
		physics.Update(delta)
	End Method
	
	Method Draw(delta:Float)
		border.Draw()
		agent.Draw()
		agent2.Draw()

		TDrawingHelper.DrawGeom(circleGeom, circleTex)
		For Local geom:TGeom = EachIn rectGeomList
			TDrawingHelper.DrawGeom(geom, rectTex)
		Next
		DrawMouseSpring()
		If physics.EnableDiagnostics Then
			view.Draw()
		End If
		If spinnerOn Then
			Local str:String = "spinner ON"
			DrawOutlineText(str, 0, 255, 0)
		Else
			Local str:String = "spinner OFF"
			DrawoutlineText(str, 255, 75, 75)
		End If		
		SetColor(255, 255, 255)
	End Method
	
	Method DrawOutlineText(str:String, r:Int, g:Int, b:Int)
			SetColor(0, 0, 0)
			DrawText(str, 512 - TextWidth(str) / 2 + 1, 384 - TextHeight(str) / 2 + 1)
			DrawText(str, 512 - TextWidth(str) / 2 - 1, 384 - TextHeight(str) / 2 - 1)
			DrawText(str, 512 - TextWidth(str) / 2 + 1, 384 - TextHeight(str) / 2 - 1)
			DrawText(str, 512 - TextWidth(str) / 2 - 1, 384 - TextHeight(str) / 2 + 1)
			SetColor(r, g, b)
			DrawText(str, 512 - TextWidth(str) / 2, 384 - TextHeight(str) / 2)
	End Method
	
	Method Load()
		physics = TPhysicsSimulator.Create(Vector2.Create(0, 150))
		view = TPhysicsSimulatorView.Create(physics)

		
		Local center:Vector2 = Vector2.Create(TDemo.gfxWidth / 2.0, TDemo.gfxHeight / 2.0)
		Local borderWidth:Int = TDemo.gfxHeight *.05
		border = TBorder.Create(TDemo.gfxWidth, TDemo.gfxHeight, borderWidth, center)
		border.Load(physics)
		
		agent = TAgent.Create(Vector2.Create(center.X - 400, 100))
		agent.SetCollidesWith(CollisionCategories.All)
		agent.Load(physics)
		
		agent2 = TAgent.Create(Vector2.Create(center.X - 400, 400))
		agent2.SetCollidesWith(CollisionCategories.All)
		agent2.SetCollisionGroup(2)
		agent2.Load(physics)
		
		' create slider joint for agents
		TJointFactory.CreateSliderJoint(physics, agent.agentBody, Vector2.Zero(), agent2.agentBody, Vector2.Zero(), 200, 400)
		
		
		Local circleRadius:Int = 50
		circleTex = TDrawingHelper.CreateCircleTexture(circleRadius, TColor.White, TColor.Red)
		MidHandleImage(circleTex)
		circleBody = TBodyFactory.CreateCircleBody(physics, circleRadius, 1)
		circleBody.SetPosition(Vector2.Create(512, 384))
		circleGeom = TGeomFactory.CreateCircleGeom(physics, circleBody, circleRadius, 10)
		TJointFactory.CreateFixedRevoluteJoint(physics, circleBody, circleBody.GetPosition())
		
		' create the arms
		Local bWidth:Int = 20
		Local bHeight:Int = 20
		Local spread:Int = 100
		rectTex = TDrawingHelper.CreateRectangleTexture(bWidth, bHeight, TColor.White, TColor.Black)
		MidHandleImage(rectTex)
		Local body1:TBody = TBodyFactory.CreateRectangleBody(physics, bWidth, bHeight, 1)
		Local geom1:TGeom = TGeomFactory.CreateRectangleGeom(physics, body1, bWidth, bHeight)
		RectGeomList.AddLast(geom1)
		body1.SetPosition(Vector2.Create(center.X, center.Y - spread))
		body1.SetRotation(Pi / 2)
		
		Local body2:TBody = TBodyFactory.CloneBody(physics, body1)
		Local body3:TBody = TBodyFactory.CloneBody(physics, body1)
		Local body4:TBody = TBodyFactory.CloneBody(physics, body1)
		body2.SetPosition(Vector2.Create(center.X - spread, center.Y))
		body3.SetPosition(Vector2.Create(center.X, center.Y + spread))
		body3.SetRotation(Pi / 2)
		
		body4.SetPosition(Vector2.Create(center.X + spread, center.Y))
		
		
		Local geom2:TGeom = TGeomFactory.CloneGeom(physics, body2, geom1)
		Local geom3:TGeom = TGeomFactory.CloneGeom(physics, body3, geom1)
		Local geom4:TGeom = TGeomFactory.CloneGeom(physics, body4, geom1)
		rectGeomList.AddLast(geom2)
		rectGeomList.AddLast(geom3)
		rectGeomList.AddLast(geom4)
		
		'setup pin joints	
		TJointFactory.CreatePinJoint(physics, body1, Vector2.Create(bWidth / 2, 0), circleBody, Vector2.Create(0, - circleRadius))
		TJointFactory.CreatePinJoint(physics, body2, Vector2.Create(bWidth / 2, 0), circleBody, Vector2.Create(- circleRadius, 0))
		TJointFactory.CreatePinJoint(physics, body3, Vector2.Create(- bWidth / 2, 0), circleBody, Vector2.Create(0, circleRadius))
		TJointFactory.CreatePinJoint(physics, body4, Vector2.Create(- bWidth / 2, 0), circleBody, Vector2.Create(circleRadius, 0))

	End Method
	
	Method Unload()
		
	End Method
	
		Method HandleKeyboardInput()
		Local forceAmount:Float = 3000
		Local force:Vector2 = Vector2.Zero() 
		
		If KeyDown(KEY_A) Then force.X:+- forceAmount
		If KeyDown(KEY_S) Then force.Y:+forceAmount
		If KeyDown(KEY_D) Then force.X:+forceAmount
		If KeyDown(KEY_W) Then force.Y:+- forceAmount
		agent.agentBody.ApplyForce(force)
		
		Local torqueAmount:Float = 14000
		Local torque:Float = 0
		If KeyDown(KEY_LEFT) Then torque:-torqueAmount
		If KeyDown(KEY_RIGHT) Then torque:+torqueAmount
		agent.agentBody.ApplyTorque(torque)
		
		If KeyHit(KEY_SPACE) Then
			spinnerOn = Not spinnerOn
		End If
		
		If KeyHit(KEY_F1) Then
			physics.EnableDiagnostics = Not physics.EnableDiagnostics
		End If
	End Method
	
	Method OnEscapeKeyHit()
		ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails())) 
	End Method
	
	Method GetTitle:String()
		Return "Pin and Slider Joints"
	End Method
	
	Method GetDetails:TStringBuilder()
		Local sb:TStringBuilder = New TStringBuilder
		sb.AppendLine("This demo shows pin and slider joints being used.")
		sb.AppendLine("The two agents (the plus sign things) are linked together by a")
		sb.AppendLine("slider joint. This means they are restricted to only be within")
		sb.AppendLine("a certain minimum and maximum range of each other. In this case")
		sb.AppendLine("they cannot get closer than 200 units within each other and no")
		sb.AppendLine("further than 400.")
		sb.AppendLine("")
		sb.AppendLine("The blocks attached to the circular body are attached by a pin joint.")
		sb.AppendLine("This joint has the same effect as the slider joint except the distance")
		sb.AppendLine("is discrete and the bodies will always be a set distance apart from")
		sb.AppendLine("each other. In this demo, the boxes are always at 100 units from their")
		sb.AppendLine("anchor point on the ball.")
		sb.AppendLine("")
		sb.AppendLine("Press F1 to see a better view of how these joints behave.")
		sb.AppendLine("")
		sb.AppendLine("Keyboard:")
		sb.AppendLine("  -Rotate : left and right arrows")
		sb.AppendLine("  -Move : A,S,D,W")
		sb.AppendLine("  -Activate Spinner: Space Bar")
		sb.AppendLine("")
		sb.AppendLine("Mouse:")
		sb.AppendLine("  -Hold down left button and drag") 
		Return sb
	End Method
End Type
